@extends('admin.layout.template')
@section('title','Order Details')

@section('content')
<style>
     .bg-body {
          background-color: #edebe5 !important;
     }
</style>
<div class="page-content">
     <div class="container-xxl">

          <div class="row">

               {{-- LEFT SIDE --}}
               <div class="col-xl-9 col-lg-8">

                    {{-- ORDER HEADER --}}
                    <div class="card mb-4">
                         <div class="card-body">

                              {{-- Header: Order Number + Payment + Status --}}
                              <div class="d-flex flex-wrap align-items-center justify-content-between gap-2">
                                   <div>
                                        <h4 class="fw-medium text-dark d-flex align-items-center gap-2">
                                             #{{ $order->order_number }}

                                             {{-- Payment Status --}}
                                             @if($order->payment_status == 'success')
                                             <span class="badge bg-success-subtle text-success px-2 py-1 fs-13">Paid</span>
                                             @elseif($order->payment_status == 'pending')
                                             <span class="badge bg-warning-subtle text-warning px-2 py-1 fs-13">Pending</span>
                                             @elseif($order->payment_status == 'failed')
                                             <span class="badge bg-danger-subtle text-danger px-2 py-1 fs-13">Failed</span>
                                             @endif

                                             {{-- Order Status --}}
                                             <span class="border 
                        @if($order->status == 'placed') border-info text-info
                        @elseif($order->status == 'processing') border-primary text-primary
                        @elseif($order->status == 'shipped') border-secondary text-secondary
                        @elseif($order->status == 'delivered') border-success text-success
                        @elseif($order->status == 'cancelled') border-danger text-danger
                        @elseif($order->status == 'returned') border-warning text-warning
                        @elseif($order->status == 'refund') border-dark text-dark
                        @endif
                        fs-13 px-2 py-1 rounded">
                                                  {{ ucfirst($order->status) }}
                                             </span>
                                        </h4>

                                        <p class="mb-0 text-muted">
                                             Order Date: {{ \Carbon\Carbon::parse($order->created_at)->format('d M Y h:i A') }}
                                        </p>
                                   </div>

                                   <div>
                                        <button class="btn btn-sm btn-primary openTrackingModal"
                                             data-id="{{ $order->id }}"
                                             data-tracking="{{ $order->tracking_id }}"
                                             data-expected="{{ $order->expected_delivery_date }}"
                                             data-delivered="{{ $order->delivered_at }}">
                                             Update Tracking
                                        </button>

                                        <button class="btn btn-sm btn-secondary openStatusModal"
                                             data-id="{{ $order->id }}"
                                             data-status="{{ $order->status }}"
                                             data-payment="{{ $order->payment_status }}">
                                             Update Status
                                        </button>

                                        <a href="{{ route('orders.invoice', $order->id) }}" class="btn btn-sm btn-success">
                                             Download Invoice
                                        </a>
                                        <td>
                                             <button class="btn btn-sm btn-danger delete-order" data-id="{{ $order->id }}" title="Delete This order">
                                                  <i class='bx bx-trash align-middle fs-16'></i> <!-- FontAwesome trash icon -->
                                             </button>
                                        </td>

                                   </div>
                              </div>

                              {{-- Progress Section --}}
                              <div class="mt-4">
                                   <h5 class="fw-medium text-dark mb-2">Progress</h5>
                                   <div class="row row-cols-xxl-5 row-cols-md-2 row-cols-1 g-3">

                                        @php
                                        $stages = ['placed', 'processing', 'shipped', 'delivered'];
                                        $colors = [
                                        'placed'=>'bg-success',
                                        'processing'=>'bg-success',
                                        'shipped'=>'bg-success',
                                        'delivered'=>'bg-success'
                                        ];
                                        @endphp

                                        @foreach($stages as $stage)
                                        @php
                                        $currentIndex = array_search($order->status, $stages);
                                        $stageIndex = array_search($stage, $stages);

                                        if($stageIndex < $currentIndex){
                                             $width=100; // previous stages fully completed
                                             $color='bg-success' ;
                                             } elseif($stageIndex==$currentIndex){
                                             $width=50; // current stage half-filled
                                             $color='bg-success' ;
                                             } else{
                                             $width=25; // upcoming stages
                                             $color='bg-secondary' ;
                                             }
                                             @endphp

                                             <div class="col">
                                             <div class="progress mt-2" style="height:8px;">
                                                  <div class="progress-bar progress-bar-striped progress-bar-animated {{ $color }}"
                                                       role="progressbar"
                                                       style="width: {{ $width }}%"
                                                       aria-valuenow="{{ $width }}" aria-valuemin="0" aria-valuemax="100">
                                                  </div>
                                             </div>
                                             <p class="mb-0 mt-1 text-center fs-13">{{ ucfirst($stage) }}</p>
                                   </div>
                                   @endforeach

                              </div>
                         </div>


                         {{-- Card Footer: Tracking Info --}}
                         <div class="card-footer d-flex flex-wrap align-items-center justify-content-between bg-light-subtle gap-2 mt-3">
                              <p class="border rounded mb-0 px-1 py-1 bg-body">
                                   <i class='bx bx-arrow-from-left align-middle fs-16'></i> Tracking ID:
                                   <span class="text-dark fw-medium">{{ $order->tracking_id ?? '-' }}</span>
                              </p>
                              <p class="border rounded mb-0 px-1 py-1 bg-body">
                                   <i class="bx bx-calendar align-middle fs-16"></i> Expected Delivery:
                                   <span class="text-dark fw-medium">
                                        {{ $order->expected_delivery_date ? \Carbon\Carbon::parse($order->expected_delivery_date)->format('d M Y') : '-' }}
                                   </span>
                              </p>
                              <p class="border rounded mb-0 px-1 py-1 bg-body">
                                   <i class="bx bx-check-circle align-middle fs-16"></i> Delivered At:
                                   <span class="text-dark fw-medium">
                                        {{ $order->delivered_at ? \Carbon\Carbon::parse($order->delivered_at)->format('d M Y h:i A') : '-' }}
                                   </span>
                              </p>
                         </div>

                    </div>
               </div>



               {{-- PRODUCTS --}}
               <div class="card">
                    <div class="card-header">
                         <h4 class="card-title">Products</h4>
                    </div>

                    <div class="card-body">

                         <div class="table-responsive">
                              <table class="table table-hover align-middle">

                                   <thead>
                                        <tr>
                                             <th>Product</th>
                                             <th>Sample ?</th>
                                             <th>Qty</th>
                                             <th>Price</th>
                                             <th>Total</th>
                                        </tr>
                                   </thead>

                                   <tbody>

                                        @foreach($order->items as $item)

                                        <tr>

                                             <td>
                                                  <div class="d-flex gap-2 align-items-center">

                                                       <img
                                                            src="{{ optional($item->variant?->primaryImage)->image_path ? asset($item->variant->primaryImage->image_path) : asset('no-image.png') }}"
                                                            width="60"
                                                            class="rounded" />

                                                       <div>
                                                            <p class="mb-0 fw-medium">{{ $item->product_name }}</p>

                                                            {{-- Variant SKU and Sample --}}
                                                            @if($item->variant)
                                                            <small class="text-muted d-block">
                                                                 SKU: {{ $item->variant->sku ?? '-' }}

                                                            </small>
                                                            @endif

                                                            {{-- Master catalog name & code --}}
                                                            @if($item->product)
                                                            <small class="text-muted d-block">
                                                                 CATALOG: {{ $item->product->master_catalogue_name ?? '-' }}
                                                                 ({{ $item->product->master_catalogue_code ?? '-' }})
                                                            </small>
                                                            @endif
                                                       </div>

                                                  </div>
                                             </td>

                                             <td>{{ $item->is_sample == 1 ? 'Sample Purchase' : 'Not Sample' }}</td>

                                             <td>{{ $item->quantity }}</td>
                                             <td>₹ {{ number_format($item->price,2) }}</td>
                                             <td>₹ {{ number_format($item->total,2) }}</td>

                                        </tr>

                                        @endforeach

                                   </tbody>
                              </table>
                         </div>

                    </div>
               </div>

               {{-- TIMELINE --}}
               <div class="card">
                    <div class="card-header">
                         <h4 class="card-title">Order Timeline</h4>
                    </div>
                    <div class="card-body">
                         <div class="position-relative ms-2">
                              {{-- Vertical dashed line --}}
                              <span class="position-absolute start-0 top-0 border border-dashed h-100"></span>

                              @foreach($order->statusHistory as $history)
                              <div class="position-relative ps-4">
                                   <div class="mb-4">
                                        {{-- Circle / Icon --}}
                                        <span class="position-absolute start-0 avatar-sm translate-middle-x bg-light d-inline-flex align-items-center justify-content-center rounded-circle text-success fs-20">
                                             <i class='bx bx-check-circle'></i>
                                        </span>

                                        {{-- Timeline Content --}}
                                        <div class="ms-2 d-flex flex-wrap gap-2 align-items-center justify-content-between">
                                             <div>
                                                  <h5 class="mb-1 text-dark fw-medium fs-15">{{ $history->status }}</h5>
                                                  @if($history->note)
                                                  <p class="mb-2">{{ $history->note }}</p>
                                                  @endif

                                                  {{-- Optional: Buttons / actions based on status --}}
                                                  @if(Str::contains(strtolower($history->status), 'invoice'))
                                                  <a href="#!" class="btn btn-light btn-sm">Resend Invoice</a>
                                                  @endif
                                             </div>

                                             {{-- Timestamp --}}
                                             <p class="mb-0">{{ \Carbon\Carbon::parse($history->created_at)->format('d M Y, h:i A') }}</p>
                                        </div>
                                   </div>
                              </div>
                              @endforeach

                         </div>
                    </div>
               </div>


          </div>

          {{-- RIGHT SIDE --}}
          <div class="col-xl-3 col-lg-4">

               {{-- ORDER SUMMARY --}}
               <div class="card mb-3">
                    <div class="card-header">
                         <h4 class="card-title">Order Summary</h4>
                    </div>
                    <div class="card-body">
                         <table class="table mb-0">
                              <tbody>
                                   <tr>
                                        <td class="px-0">
                                             <p class="d-flex mb-0 align-items-center gap-1">
                                                  <iconify-icon icon="solar:clipboard-text-broken"></iconify-icon> Sub Total :
                                             </p>
                                        </td>
                                        <td class="text-end text-dark fw-medium px-0">
                                             ₹ {{ number_format($order->sub_total, 2) }}
                                        </td>
                                   </tr>

                                   <tr>
                                        <td class="px-0">
                                             <p class="d-flex mb-0 align-items-center gap-1">
                                                  <iconify-icon icon="solar:ticket-broken" class="align-middle"></iconify-icon> Discount :
                                             </p>
                                        </td>
                                        <td class="text-end text-dark fw-medium px-0">
                                             ₹ {{ number_format($order->discount, 2) }}
                                        </td>
                                   </tr>

                                   <tr>
                                        <td class="px-0">
                                             <p class="d-flex mb-0 align-items-center gap-1">
                                                  <iconify-icon icon="solar:kick-scooter-broken" class="align-middle"></iconify-icon> Delivery Fee :
                                             </p>
                                        </td>
                                        <td class="text-end text-dark fw-medium px-0">
                                             ₹ {{ number_format($order->delivery_fee, 2) }}
                                        </td>
                                   </tr>

                                   <!-- <tr>
            <td class="px-0">
                <p class="d-flex mb-0 align-items-center gap-1">
                    <iconify-icon icon="solar:calculator-minimalistic-broken" class="align-middle"></iconify-icon> Estimated Tax (15.5%) :
                </p>
            </td>
            <td class="text-end text-dark fw-medium px-0">
                ₹ {{ number_format($order->tax_amount, 2) }}
            </td>
        </tr> -->

                                   <tr class="border-top">
                                        <td class="px-0">
                                             <p class="d-flex mb-0 align-items-center gap-1 fw-bold">
                                                  <iconify-icon icon="solar:wallet-broken"></iconify-icon> Total :
                                             </p>
                                        </td>
                                        <td class="text-end text-dark fw-bold px-0">
                                             ₹ {{ number_format($order->total_amount, 2) }}
                                        </td>
                                   </tr>
                              </tbody>
                         </table>

                    </div>
                    <div class="card-footer d-flex justify-content-between">
                         <strong>Total</strong>
                         <strong>₹ {{ number_format($order->total_amount, 2) }}</strong>
                    </div>
               </div>

               {{-- PAYMENT --}}
               <div class="card mb-3">
                    <div class="card-header">
                         <h4 class="card-title">Payment</h4>
                    </div>
                    <div class="card-body">
                         <p>Method : {{ $order->payment_method }}</p>
                         <p>Status :
                              @if($order->payment_status=='paid')
                              <span class="badge bg-success">Paid</span>
                              @else
                              <span class="badge bg-warning">Pending</span>
                              @endif
                         </p>

                         {{-- Razorpay Details --}}
                         @if($order->razorpay_order_id)
                         <p>Razorpay Order ID: {{ $order->razorpay_order_id }}</p>
                         <p>Razorpay Payment ID: {{ $order->razorpay_payment_id }}</p>
                         <p>Razorpay Signature: {{ $order->razorpay_signature }}</p>
                         @endif

                         {{-- Coupon --}}
                         @if($order->coupon_code)
                         <p>Coupon Applied: {{ $order->coupon_code }}</p>
                         @endif
                    </div>
               </div>

               {{-- SHIPPING ADDRESS --}}
               <div class="card mb-3">
                    <div class="card-header">
                         <h4 class="card-title">Shipping Address</h4>
                    </div>
                    <div class="card-body">
                         @if($order->shippingAddress)
                         <p>{{ $order->shippingAddress->name }}</p>
                         <p>{{ $order->shippingAddress->address_line1 }}</p>
                         <p>{{ $order->shippingAddress->city }}, {{ $order->shippingAddress->state }}</p>
                         <p>{{ $order->shippingAddress->phone }}</p>
                         @endif
                    </div>
               </div>

               {{-- BILLING ADDRESS --}}
               <div class="card mb-3">
                    <div class="card-header">
                         <h4 class="card-title">Billing Address</h4>
                    </div>
                    <div class="card-body">
                         @if($order->billingAddress)
                         <p>{{ $order->billingAddress->name }}</p>
                         <p>{{ $order->billingAddress->address_line1 }}</p>
                         <p>{{ $order->billingAddress->city }}, {{ $order->billingAddress->state }}</p>
                         <p>{{ $order->billingAddress->phone }}</p>
                         @endif
                    </div>
               </div>

               {{-- COURIER --}}
               @if($order->courier)
               <div class="card mb-3">
                    <div class="card-header">
                         <h4 class="card-title">Courier</h4>
                    </div>
                    <div class="card-body">
                         @if($order->courier->logo)
                         <img src="{{ asset($order->courier->logo) }}" width="80" class="mb-2" />
                         @endif
                         <p>{{ $order->courier->name }}</p>
                         <p>Tracking ID : {{ $order->tracking_id }}</p>
                         @if($order->courier->website)
                         <a href="{{ $order->courier->website }}" target="_blank">Track Shipment</a>
                         @endif
                    </div>
               </div>
               @endif

          </div>


     </div>
</div>
</div>
<div class="modal fade" id="trackingModal">
     <div class="modal-dialog">
          <div class="modal-content">

               <div class="modal-header">
                    <h5 class="modal-title">Update Tracking Details</h5>
                    <button type="button" class="btn-close"
                         data-bs-dismiss="modal"></button>
               </div>

               <div class="modal-body">

                    <input type="hidden" id="order_id">

                    <div class="form-group mb-3">
                         <label>Tracking ID</label>
                         <input type="text" class="form-control" id="tracking_id">
                    </div>

                    <div class="form-group mb-3">
                         <label>Expected Delivery Date</label>
                         <input type="date" class="form-control" id="expected_delivery_date">
                    </div>

                    <div class="form-group mb-3">
                         <label>Delivered At</label>
                         <input type="datetime-local" class="form-control" id="delivered_at">
                    </div>

               </div>

               <div class="modal-footer">
                    <button class="btn btn-success" id="saveTracking">Save</button>
               </div>

          </div>
     </div>
</div>

<div class="modal fade" id="statusModal">
     <div class="modal-dialog">
          <div class="modal-content">

               <div class="modal-header">
                    <h5>Update Order Status & Payment</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
               </div>

               <div class="modal-body">
                    <input type="hidden" id="order_id">

                    <label>Order Status</label>
                    <select class="form-control mb-3" id="order_status">
                         <option value="placed">Placed</option>
                         <option value="processing">Processing</option>
                         <option value="shipped">Shipped</option>
                         <option value="delivered">Delivered</option>
                         <option value="cancelled">Cancelled</option>
                         <option value="returned">Returned</option>
                         <option value="refund">Refund</option>
                    </select>

                    <label>Payment Status</label>
                    <select class="form-control mb-3" id="payment_status">
                         <option value="pending">Pending</option>
                         <option value="success">Success</option>
                         <option value="failed">Failed</option>
                    </select>

                    <label>Optional Note</label>
                    <textarea name="note" class="form-control mb-3" id="order_note" placeholder="Optional Note"></textarea>
               </div>

               <div class="modal-footer">
                    <button class="btn btn-primary" id="saveStatusBtn">Update</button>
               </div>

          </div>
     </div>
</div>


<script>
     $(document).on('click', '.openStatusModal', function() {
          let orderId = $(this).data('id');
          let status = $(this).data('status');
          let payment = $(this).data('payment');

          $('#order_id').val(orderId);
          $('#order_status').val(status);
          $('#payment_status').val(payment);
          $('#order_note').val('');

          $('#statusModal').modal('show');
     });

     $('#saveStatusBtn').click(function() {
          let id = $('#order_id').val();
          let status = $('#order_status').val();
          let payment_status = $('#payment_status').val();
          let note = $('#order_note').val();

          Swal.fire({
               title: 'Update Order?',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonText: 'Yes Update'
          }).then((result) => {
               if (result.isConfirmed) {
                    let url = "{{ route('orders.status', ':id') }}";
                    url = url.replace(':id', id);

                    $.post(url, {
                         _token: '{{ csrf_token() }}',
                         status: status,
                         payment_status: payment_status,
                         note: note
                    }, function(res) {
                         Swal.fire('Updated!', res.message, 'success')
                              .then(() => location.reload());
                    });
               }
          });
     });



     $(document).on('click', '.openTrackingModal', function() {

          $('#order_id').val($(this).data('id'));
          $('#tracking_id').val($(this).data('tracking'));
          $('#expected_delivery_date').val($(this).data('expected'));
          $('#delivered_at').val($(this).data('delivered'));

          $('#trackingModal').modal('show');

     });
     $('#saveTracking').click(function() {
          Swal.fire({
               title: 'Update order details?',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonText: 'Yes Update'
          }).then((result) => {

               if (result.isConfirmed) {
                    $.ajax({
                         //url:'/admin/order/update-tracking',
                         url: "{{ url('admin/order/update-tracking') }}/",
                         type: 'POST',
                         data: {
                              _token: '{{ csrf_token() }}',
                              order_id: $('#order_id').val(),
                              tracking_id: $('#tracking_id').val(),
                              expected_delivery_date: $('#expected_delivery_date').val(),
                              delivered_at: $('#delivered_at').val(),
                         },

                         success: function(res) {

                              if (res.success) {

                                   $('#trackingModal').modal('hide');
                                   location.reload();

                              }

                         }
                    });

               }

          });



     });

     $(document).on('click', '.delete-order', function() {
          let orderId = $(this).data('id');
          Swal.fire({
               title: 'Are you sure ?. You want to delete this order?',
               icon: 'warning',
               showCancelButton: true,
               confirmButtonText: 'Yes Update'
          }).then((result) => {

               if (result.isConfirmed) {
                    $.ajax({
                         url: "{{ url('/orders/delete') }}",
                         type: 'POST',
                         data: {
                              order_id: orderId,
                              _token: '{{ csrf_token() }}'
                         },
                         success: function(res) {
                              if (res.success) {

                                   // Optionally remove the row
                                   window.location = "{{route('orders.index')}}";
                                   $('button[data-id="' + orderId + '"]').closest('tr').remove();
                              } else {
                                   alert(res.message || 'Something went wrong!');
                              }
                         },
                         error: function(err) {
                              alert('Error deleting order.');
                              console.error(err);
                         }
                    });

               }

          });
     });
</script>



@endsection